///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef NetworkDLS_Algorithmic_Symmetric_Cipher_Cryptography_Library_NASCCL_H
#define NetworkDLS_Algorithmic_Symmetric_Cipher_Cryptography_Library_NASCCL_H
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef unsigned char NTYPE;

#define SALT_BOXES   64
#define SALT_VALUES 256

extern NTYPE sKeySalt[SALT_BOXES][SALT_VALUES];
extern const NTYPE sHardSalt[SALT_BOXES][SALT_VALUES];

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class NASCCL{

	public:
		int HashKey(const void *sRawKey, void *sKeyHash, int iRawKeySz, int iKeyHashSz);
		int CipherKey(const void *sRawKey, void *sKeyHash, int iRawKeySz);
		bool InitializeCryptographyEx(void *lpKey, unsigned int iKeySz, bool bAutoReset);
    	bool InitializeCryptography(const char *sKey);
    	void DestroyCryptography(void);
    	void CipherEx(const void *lpBuf, void *lpTarget, unsigned int iBufSz);
    	void Cipher(void *lpBuf, unsigned int iBufSz);
    	void ResetCryptography(void);
    	void MutateKey(void);

	private:
		bool bReset;

    	void BuildSBox(void);
		void ZeroKeyBox(void);

    	NTYPE *sKeyBuf;
    	unsigned int iKeySz;
    	unsigned int iKeyPos;
    	unsigned int iSBox;
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
